# 需求分析和产品规划

> 想清楚要做什么，才能做得更好



大家好，我是鱼皮。在做任何产品前，我们首先必须要做的一件事是 **需求分析**。

何为需求分析？简单来说，就是分析和明确用户的需求。

那为什么要做需求分析？怎么做好需求分析？有没有什么注意事项呢？

这篇文章，我会结合自己做产品的经验，带大家了解需求分析的方法和技巧。无论你是用 Vibe Coding 做个人项目，还是想做一款真正的产品，这些方法都能帮到你。



## 为什么要做需求分析？

我给大家举一个自己的亲身经历，有次某个多年未见的好哥们来上海找我玩，因为关系很好嘛，我想着请他吃一顿海鲜自助餐，直接就预定好了。结果呢，等我带他到海鲜店的时候，他跟我说：哥们海鲜过敏啊。。。

结果就很尴尬，白白浪费了预定金和时间。这便是没有进行需求分析的结果。

在我们开发项目、做产品前也是同样的道理，如果你只凭自己的一时兴起、或者主观推测去做一些事情，而忽略了用户的真实需求，就有可能花了大量的人力物力，结果做出了一款用户完全不需要的产品。

像我早期做编程知识分享时，就吃了没有做需求分析的亏，凭着一腔热血更新了很多自以为有用的视频，也没有什么点赞量。后来再看，不过是自嗨而已。

所以，需求分析是至关重要的。可以把它想象成一座桥梁，连接我们的产品和用户的桥梁，能够帮我们更好地通往用户的心房，明确我们要做的事情。

> 注意，需求分析不是产品经理和老板才要做的！对于程序员来说，需求分析同样至关重要，这决定了你之后的开发工作到底有没有意义，千万不要做个只会听命令敲代码的 “机器人”。



## 需求分析都要做什么？

关于需求分析，网上有很多的方法论，我对这些方法进行了归纳总结，从 3 个方面讲给大家。



### 三个方面

第一个方面是 **从自己出发** ，我给它取名为 “free analysis”（自由分析）。做产品本来就应该是一件很有趣的事情，哪来那么多的条条框框，自己有什么想法、想做什么，就先尽可能多地自由记录下来。

我在决定做鱼聪明 AI 时，就已经大致想好了要做哪些功能，比如大家都有的 AI 对话、AI 绘画、AI Mask、AI 导航、AI 写书等，这一步不需要真的去做 “分析”，只需要尽情想象、发散思维即可。

第二个方面是 **从用户出发** 。你如果只是为了学习、自己做着玩，那么只做第一个方面的自由分析，也是合理的。但如果你想做出一款吸引人的、有更多人用的线上产品，肯定是要回归用户、以用户为核心。

一句话：确认 **用户需要什么、有什么痛点** ，以此来筛选或改进我们要做的功能，避免自嗨。

有很多的方法，比如常见的问卷调查、和用户交流、开会讨论等等。对我们创业小团队来说，我们本身就是用户，所以我们做需求分析时，首先就是大家一起开会讨论，每个人思考一下 “自己会不会用到这个功能”。如果某个功能我们自己都觉得不会用，那么铁定不去做；而如果某个功能大家都觉得 “握草，这个牛” ，那么这可能是我们的核心亮点功能。

第三个方面是 **从竞品出发** ，也就是所谓的竞品分析了。在你还不明确要做什么功能、没有想法的时候，去体验下同类的产品，相信你会多很多想法。

很多学编程的同学经常问：怎么扩展项目？答案就是：去看同类项目有什么功能，给你的项目也加上即可。

不过有一点要注意，你的竞品也未必在某个功能上做到了极致，在体验竞品时，可以记录下自己真实的使用体验，取其精华去其糟粕，就有超越他们的可能性。



### 明确需求

通过以上 3 个方面的思考和实践，我们基本可以确认要做的核心功能了（类比为你写作文时写好了大纲）。

接下来就要把需求进一步拆解和细化，尽量把每个小功能点、以及具体要做什么都明确好（类比为你要根据大纲填充内容）。

比如我们鱼聪明 AI 要做的核心功能是 AI 对话，可以拆解为：

1. 创建 AI 对话
2. 查看我的 AI 对话列表
3. 查看对话信息
4. 发送对话消息
5. AI 智能回答
6. 查看对话消息记录
7. 消息工具栏

还可以再把某些功能进一步拆分，比如消息工具栏又分为：复制消息、语音朗读、下载消息等等。



### 优先级编排 

当我们细化需求后，可能会惊讶地发现：竟然有那么多要做的事情！

这个时候呢，有些同学可能就打算放弃了：这么麻烦，不做了不做了！

别慌，任何系统不可能一步到位，我们要做的是给需求编排好优先级，决定先做哪个、后做哪个，然后一步步去实现。

那么怎么划分优先级呢？

比较常见的方法就是基于需求的重要性、紧急程度、影响范围、实施复杂度等因素，把需求分为 P0 - P3 这 4 个级别。

- P0：优先级最高的需求，必须有。没有这个功能网站就不能上线。比如鱼聪明 AI 的对话和内容审核功能。
- P1：优先要做的需求，最好有。一般是指在初期并不紧急，但后续必须要做的亮眼功能。比如鱼聪明 AI 的分享、以图生图功能。
- P2：优先级适中的需求，可以有。一般是指可以提高用户体验、带来部分价值的需求，时间资源允许的情况下可以做。比如鱼聪明 AI 的助手高级配置功能。
- P3：优先级最低的需求，可有可无。要么就是带来的价值较低，要么就是实现复杂度较高，可以等团队有人摸鱼的时候，再去做。比如鱼聪明 AI 的。。。呃我们貌似还没有 P3 的需求，没人能在鱼皮手下摸鱼（🐶 开个玩笑） ！

这么划分优先级后，大家就优先去做 P0 就好了，P0 做完先上线一版，快速找用户验证下需求是否真的合理、能带来价值，再进行后续的开发和迭代。



### 需求管理

哪怕是在初期需求不多的时候，也是需要记录和管理需求的。而不是把上面所有的信息存到你的脑海中，不然就会出现 “唉，我当时为啥要做这个功能？” 的情况。

那么如何进行需求管理呢？

最简单的方式就是用文档来记录，不用把这件事想的很复杂，就像你记录今天自己要吃什么一样，用一个列表写下来就好了。

推荐使用语雀、飞书等在线知识库网站，而不是本地记录，这样能够和团队的同学即时同步消息、协同编辑。

相对正规一点，可以使用表格来搞一个需求排期表，记录下每个功能、模块、详情、优先级等信息

![](https://pic.yupi.icu/1/image-20230704115312375.png)

还可以使用 XMind 等思维导图工具，对需求进行一个层级的划分，不仅团队协作时会更清晰，做 PPT 拉融资的时候也会更好看一些。

再正规一点的话，可以使用 Jira、Tapd、Teambition 等专业的需求（项目）管理系统，可以帮助管理更复杂、多依赖的需求。

注意，需求管理是一件持续要做的事情。而且并不是说所有的需求和功能你都能立刻想到，但是一旦有任何的想法和灵感，千万不要错过，要立即掏出手机记录下来！



## 别让伪需求害了你！

最后但是最重要的一点，别让伪需求害了你！

这句话不仅是说给产品经理和老板听的，更是给所有要实际做需求的同学（比如程序员、测试）重点强调的。

如果把完整的系统功能比喻成拼图，伪需求就像是一块残缺的不规则图块，看起来好像是有点儿用的，但实际上不能帮助我们完成拼图、浪费我们的时间。

那么，我们如何避免伪需求呢？

除了上面说的需求分析、用户反馈、编排优先级、需求管理外，我们还应该让团队尽可能多的同学参与进来，多交流和验证、反复评估，还可以用数据分析等手段科学验证。

我们每位同学作为团队的一员，也都应该主动申请介入需求评审，掌握更多的信息，帮助团队做出更正确的决策。

有些时候，我们作为企业大团队的一名小开发，可能无法过多地参与需求的分析和项目的决策。但是如果发现需求是不合理的，也应该尽早提出和反馈，而不是傻傻地费时费力做了个没用的需求（甚至是没用的系统）。

我们的鱼聪明 AI，其实也有伪需求，也是因为我的一个决策失误吧，做出了一个几乎没有用的功能。不过后面我们通过某种手段发现了这点并且对系统做了优化，当然，这是后话，在以后的章节中会给大家分享。

所以，开发同学们再遇到伪需求时，希望能理直气壮地跟产品说：这个需求不合理！这个需求我不做！



---



## 写在最后

需求分析是做好产品的第一步，也是最重要的一步。无论你是用 Vibe Coding 做个人项目，还是想做一款真正的产品，都要重视需求分析。

记住这几个关键点：

1. 需求分析要从自己、用户、竞品三个方面出发
2. 要把需求细化为具体的功能点
3. 要给需求编排好优先级，先做核心功能
4. 要持续管理和优化需求
5. 要警惕伪需求，多交流多验证

在 Vibe Coding 时代，实现需求的成本已经很低了。但是，想清楚要做什么，仍然是最重要的。只有方向对了，才能事半功倍。

加油，期待看到你做出有价值的产品！💪


## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
